
import Image from "next/image";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Check, Users, Briefcase, Target, Lightbulb } from "lucide-react";
import { APP_NAME } from "@/constants";
import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'About Us',
  description: `Learn about ${APP_NAME}'s mission, vision, values, history, and the team dedicated to empowering communities.`,
};

const teamMembers = [
  { name: "Alice Wamuyu", role: "CEO & Founder", image: "https://placehold.co/300x300.png", hint: "professional woman" },
  { name: "John Okello", role: "Head of Operations", image: "https://placehold.co/300x300.png", hint: "professional man" },
  { name: "Fatuma Ahmed", role: "Lead Financial Inclusion Specialist", image: "https://placehold.co/300x300.png", hint: "business person" },
  { name: "David Kimani", role: "Digital Innovation Lead", image: "https://placehold.co/300x300.png", hint: "tech expert" },
];

export default function AboutPage() {
  return (
    <div className="bg-background text-foreground">
      {/* Hero Section */}
      <section className="py-20 md:py-28 bg-primary/5">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-primary mb-4 text-shadow-primary">About {APP_NAME}</h1>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Driving sustainable development in East Africa through expertise in financial inclusion, enterprise growth, and innovative solutions.
          </p>
        </div>
      </section>

      {/* Our Story Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div>
              <Image
                src="https://files.tari.africa/api.php?path=public&name=1748419674_6836c45a76d77.png"
                alt="Intelli-Wealth team strategic planning"
                width={600}
                height={400}
                className="rounded-lg shadow-xl object-cover"
                data-ai-hint="team strategy"
              />
            </div>
            <div>
              <h2 className="text-3xl font-bold text-foreground mb-6">Our Journey</h2>
              <p className="text-muted-foreground mb-4">
                Intelli-Wealth Limited was established in 2016 in Nairobi, Kenya, with a clear vision: to become a leading management consulting firm specializing in financial inclusion, enterprise development, and experiential marketing across East Africa.
              </p>
              <p className="text-muted-foreground mb-4">
                Since our inception, we have been committed to empowering communities, particularly women and youth. We achieve this through comprehensive financial literacy programs, targeted agribusiness training, and the development of innovative digital solutions designed to enhance transparency and efficiency.
              </p>
              <p className="text-muted-foreground">
                Our work spans across Kenya, Uganda, Tanzania, and Rwanda, where we collaborate with diverse partners to implement impactful projects that foster economic growth and improve livelihoods.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Mission, Vision, Values Section */}
      <section className="py-16 lg:py-24 bg-muted/30">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-3 gap-8 text-center">
            <Card className="shadow-lg">
              <CardHeader>
                <Target className="h-12 w-12 text-primary mx-auto mb-4" />
                <CardTitle className="text-2xl text-primary text-shadow-primary">Our Mission</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">To empower communities—particularly women and youth—through financial literacy, agribusiness training, and innovative digital solutions.</p>
              </CardContent>
            </Card>
            <Card className="shadow-lg">
              <CardHeader>
                <Lightbulb className="h-12 w-12 text-primary mx-auto mb-4" />
                <CardTitle className="text-2xl text-primary text-shadow-primary">Our Vision</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">To be the leading catalyst for sustainable economic development and financial inclusion across East Africa.</p>
              </CardContent>
            </Card>
            <Card className="shadow-lg">
              <CardHeader>
                <Check className="h-12 w-12 text-primary mx-auto mb-4" />
                <CardTitle className="text-2xl text-primary text-shadow-primary">Our Core Values</CardTitle>
              </CardHeader>
              <CardContent>
                <ul className="text-muted-foreground space-y-1 list-none">
                  <li>Integrity &amp; Transparency</li>
                  <li>Innovation &amp; Excellence</li>
                  <li>Community Empowerment</li>
                  <li>Collaboration &amp; Partnership</li>
                  <li>Sustainability</li>
                </ul>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Our Team Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl lg:text-4xl font-bold text-foreground">Meet Our Team</h2>
            <p className="mt-4 text-lg text-muted-foreground max-w-2xl mx-auto">
              A dedicated group of professionals passionate about driving positive change.
            </p>
          </div>
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            {teamMembers.map((member) => (
              <Card key={member.name} className="text-center shadow-md hover:shadow-lg transition-shadow duration-300">
                <CardContent className="pt-6">
                  <Image
                    src={member.image}
                    alt={member.name}
                    width={120}
                    height={120}
                    className="rounded-full mx-auto mb-4 object-cover"
                    data-ai-hint={member.hint}
                  />
                  <h3 className="text-lg font-semibold text-primary text-shadow-primary">{member.name}</h3>
                  <p className="text-sm text-accent">{member.role}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Areas of Expertise */}
       <section className="py-16 lg:py-24 bg-primary/5">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl lg:text-4xl font-bold text-foreground">Our Expertise</h2>
            <p className="mt-4 text-lg text-muted-foreground max-w-2xl mx-auto">
              Leveraging deep knowledge and practical experience to deliver impactful results.
            </p>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {[
              { title: "Enterprise Development", icon: Briefcase },
              { title: "Financial Inclusion", icon: Users },
              { title: "Digital Innovation", icon: Lightbulb },
              { title: "Experiential Marketing", icon: Target }
            ].map(expertise => (
              <Card key={expertise.title} className="shadow-md">
                <CardHeader className="items-center text-center">
                  <expertise.icon className="h-10 w-10 text-primary mb-3" />
                  <CardTitle className="text-xl text-primary text-shadow-primary">{expertise.title}</CardTitle>
                </CardHeader>
                <CardContent className="text-center">
                  <p className="text-sm text-muted-foreground">
                    We provide specialized strategies and implementation support in {expertise.title.toLowerCase()} to help organizations and communities thrive.
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>
    </div>
  );
}
