import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Rss, MessageSquareText, Lightbulb } from "lucide-react";
import Link from "next/link";
import { APP_NAME } from "@/constants";
import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'News & Insights',
  description: `Stay updated with the latest news, articles, and thought leadership from ${APP_NAME} on financial inclusion, enterprise development, and digital innovation.`,
};

const placeholderArticles = [
  { id: 1, title: "The Digital Leap: Transforming VSLAs in Rural Kenya", date: "October 26, 2023", category: "Financial Inclusion", icon: Rss, summary: "Exploring the impact of mobile technology on traditional savings groups and financial accessibility." },
  { id: 2, title: "Unlocking SME Potential: Strategies for Growth in East Africa", date: "November 10, 2023", category: "Enterprise Development", icon: Lightbulb, summary: "Key insights into overcoming challenges and fostering sustainable growth for small and medium enterprises." },
  { id: 3, title: "Experiential Marketing: Connecting Brands with Communities", date: "November 22, 2023", category: "Marketing", icon: MessageSquareText, summary: "How meaningful engagement can build brand loyalty and drive impact in diverse markets." },
];

export default function NewsInsightsPage() {
  return (
    <div className="bg-background text-foreground">
      {/* Hero Section */}
      <section className="py-20 md:py-28 bg-primary/5">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-primary mb-4 text-shadow-primary">News & Insights</h1>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Stay informed with the latest articles, updates, and thought leadership from {APP_NAME}.
          </p>
        </div>
      </section>

      {/* Content Placeholder Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <Rss className="h-16 w-16 text-accent mx-auto mb-4" />
            <h2 className="text-3xl font-bold text-foreground mb-4">Coming Soon!</h2>
            <p className="text-lg text-muted-foreground max-w-xl mx-auto">
              Our News & Insights section is currently under development. We're working hard to bring you valuable content on financial inclusion, enterprise development, digital innovation, and more.
            </p>
            <p className="text-lg text-muted-foreground max-w-xl mx-auto mt-2">
              Check back soon for updates!
            </p>
          </div>

          {/* Placeholder for Future Articles */}
          <div className="mt-16">
            <h3 className="text-2xl font-semibold text-center text-foreground mb-8">What to Expect</h3>
            <div className="grid md:grid-cols-3 gap-8">
              {placeholderArticles.map(article => (
                <Card key={article.id} className="shadow-lg hover:shadow-xl transition-shadow duration-300">
                  <CardHeader>
                    <div className="flex items-center text-accent mb-2">
                      <article.icon className="h-5 w-5 mr-2" />
                      <span className="text-sm font-medium">{article.category}</span>
                    </div>
                    <CardTitle className="text-xl text-primary text-shadow-primary">{article.title}</CardTitle>
                    <CardDescription className="text-xs">{article.date}</CardDescription>
                  </CardHeader>
                  <CardContent>
                    <p className="text-sm text-muted-foreground">{article.summary}</p>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>

          <div className="text-center mt-16">
            <p className="text-muted-foreground mb-4">In the meantime, explore our work or get in touch:</p>
            <div className="flex justify-center gap-4">
              <Button asChild>
                <Link href="/projects">View Our Projects</Link>
              </Button>
              <Button variant="outline" asChild>
                <Link href="/contact">Contact Us</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}
