
import { ProjectCard } from "@/components/projects/project-card";
import { APP_NAME } from "@/constants";
import type { Metadata } from 'next';
import { getPublicProjects } from "@/lib/actions";
import type { Project } from "@/types";

export const metadata: Metadata = {
  title: 'Our Projects',
  description: `Discover impactful projects and success stories by ${APP_NAME}, showcasing our work in financial inclusion, enterprise development, and more across East Africa.`,
};

export default async function ProjectsPage() {
  const projects: Project[] = await getPublicProjects();

  return (
    <div className="bg-background text-foreground">
      {/* Hero Section */}
      <section className="py-20 md:py-28 bg-primary/5">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-primary mb-4 text-shadow-primary">Our Projects</h1>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Showcasing our commitment to creating tangible, positive change through collaborative and innovative initiatives.
          </p>
        </div>
      </section>

      {/* Projects Grid Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          {projects.length > 0 ? (
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {projects.map((project) => (
                <ProjectCard key={project.id} project={project} />
              ))}
            </div>
          ) : (
            <p className="text-center text-muted-foreground text-lg">
              Currently, there are no projects to display. Please check back later or contact us for more information about our work.
            </p>
          )}
        </div>
      </section>

       {/* Additional Projects Teaser / Future Projects */}
      <section className="py-16 lg:py-24 bg-muted/30">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold text-foreground mb-6">
            And Many More...
          </h2>
          <p className="text-lg text-muted-foreground mb-8 max-w-2xl mx-auto">
            {APP_NAME} is continuously involved in new and exciting projects. We are dedicated to expanding our reach and impact. Stay tuned for updates on our latest initiatives.
          </p>
          <a
            href="/contact"
            className="inline-flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-primary-foreground bg-primary hover:bg-primary/90"
          >
            Partner With Us
          </a>
        </div>
      </section>
    </div>
  );
}
