import { ServiceCard } from "@/components/services/service-card";
import { CORE_SERVICES, APP_NAME } from "@/constants";
import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Our Services',
  description: `Explore the comprehensive services offered by ${APP_NAME}, including Enterprise Development, Financial Inclusion, Digital Innovation, and Experiential Marketing.`,
};

export default function ServicesPage() {
  return (
    <div className="bg-background text-foreground">
      {/* Hero Section */}
      <section className="py-20 md:py-28 bg-primary/5">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-primary mb-4 text-shadow-primary">Our Services</h1>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Delivering comprehensive solutions to foster growth, inclusion, and innovation across East Africa.
          </p>
        </div>
      </section>

      {/* Services Grid Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-12">
            {CORE_SERVICES.map((service) => (
              <ServiceCard key={service.id} service={service} />
            ))}
          </div>
        </div>
      </section>

      {/* Call to Action Section */}
      <section className="py-16 lg:py-24 bg-muted/30">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold text-foreground mb-6">
            Ready to drive impact with {APP_NAME}?
          </h2>
          <p className="text-lg text-muted-foreground mb-8 max-w-2xl mx-auto">
            Whether you're looking to develop your enterprise, enhance financial inclusion, embrace digital transformation, or create memorable brand experiences, we have the expertise to help you succeed.
          </p>
          <a
            href="/contact"
            className="inline-flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-primary-foreground bg-primary hover:bg-primary/90"
          >
            Get in Touch
          </a>
        </div>
      </section>
    </div>
  );
}
