
"use client"; 

import Link from 'next/link';
import Image from 'next/image';
import { useState } from 'react';
import {
  Sidebar,
  SidebarProvider,
  SidebarHeader,
  SidebarContent,
  SidebarFooter,
  SidebarMenu,
  SidebarMenuItem,
  SidebarMenuButton,
} from '@/components/ui/sidebar';
import { Button } from '@/components/ui/button';
import { Sheet, SheetContent, SheetTrigger, SheetClose, SheetTitle } from '@/components/ui/sheet';
import { APP_NAME, LOGO_URL as FALLBACK_LOGO_URL } from '@/constants';
import { FolderKanban, Briefcase, Newspaper, LayoutDashboard, UserCircle, Menu as MenuIcon, ImageIcon, Settings as SettingsIcon } from 'lucide-react'; 
import { LogoutButton } from '@/components/staff-portal/logout-button';
import { useSiteSettingsContext } from "@/context/site-settings-provider"; // Import context hook

export default function DashboardLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);
  const siteSettings = useSiteSettingsContext();
  const currentLogoUrl = siteSettings?.logoUrl || FALLBACK_LOGO_URL;

  const sidebarMenuContent = (
    <>
      <SidebarHeader className="p-4 border-b">
        <Link href="/staff-portal/dashboard" className="flex items-center gap-2">
          <Image src={currentLogoUrl} alt={`${APP_NAME} Logo`} width={30} height={30} className="object-contain" />
          <span className="text-lg font-semibold text-primary text-shadow-primary group-data-[collapsible=icon]:hidden">
            {`${APP_NAME} Staff`}
          </span>
        </Link>
      </SidebarHeader>
      <SidebarContent className="p-2 flex-grow">
        <SidebarMenu>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard" asChild>
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Dashboard"
              >
                <LayoutDashboard />
                <span className="group-data-[collapsible=icon]:hidden">Dashboard</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard/admin-projects" asChild>
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Projects"
              >
                <FolderKanban />
                <span className="group-data-[collapsible=icon]:hidden">Projects</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard/admin-images" asChild>
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Images"
              >
                <ImageIcon />
                <span className="group-data-[collapsible=icon]:hidden">Images</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
           <SidebarMenuItem>
            <Link href="/staff-portal/dashboard/settings" asChild>
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Settings"
              >
                <SettingsIcon />
                <span className="group-data-[collapsible=icon]:hidden">Settings</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard#services" asChild> 
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Services Management"
              >
                <Briefcase />
                <span className="group-data-[collapsible=icon]:hidden">Services</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard#news" asChild> 
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="News & Insights Mgt."
              >
                <Newspaper />
                <span className="group-data-[collapsible=icon]:hidden">News & Insights</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
          <SidebarMenuItem>
            <Link href="/staff-portal/dashboard/profile" asChild>
              <SidebarMenuButton
                className="w-full justify-start"
                tooltip="Profile"
              >
                <UserCircle />
                <span className="group-data-[collapsible=icon]:hidden">Profile</span>
              </SidebarMenuButton>
            </Link>
          </SidebarMenuItem>
        </SidebarMenu>
      </SidebarContent>
      <SidebarFooter className="p-4 border-t">
        <LogoutButton />
      </SidebarFooter>
    </>
  );


  return (
    <SidebarProvider defaultOpen={true}> 
      <div className="flex min-h-screen bg-muted/20">
        <Sidebar
          collapsible="icon" 
          className="hidden md:flex md:flex-col border-r bg-background shadow-sm w-64 data-[collapsed=true]:w-16 transition-all duration-300 ease-in-out"
        >
          {sidebarMenuContent}
        </Sidebar>

        <div className="flex flex-col flex-1">
          <header className="md:hidden sticky top-0 z-40 flex h-14 items-center gap-4 border-b bg-background px-4 sm:h-16 sm:px-6">
            <Sheet open={isMobileMenuOpen} onOpenChange={setIsMobileMenuOpen}>
              <SheetTrigger asChild>
                <Button
                  variant="outline"
                  size="icon"
                  className="shrink-0"
                  aria-label="Toggle mobile menu"
                >
                  <MenuIcon className="h-5 w-5" />
                </Button>
              </SheetTrigger>
              <SheetContent side="left" className="flex flex-col p-0 w-64 sm:w-72">
                <div className="flex flex-col h-full"> 
                  <SidebarHeader className="p-4 border-b">
                    <SheetClose asChild>
                      <Link href="/staff-portal/dashboard" className="flex items-center gap-2">
                        <Image src={currentLogoUrl} alt={`${APP_NAME} Logo`} width={30} height={30} className="object-contain" />
                        <SheetTitle asChild>
                          <span className="text-lg font-semibold text-primary text-shadow-primary">
                            {`${APP_NAME} Staff`}
                          </span>
                        </SheetTitle>
                      </Link>
                    </SheetClose>
                  </SidebarHeader>
                  <SidebarContent className="p-2 flex-grow overflow-y-auto">
                    <SidebarMenu>
                      <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <LayoutDashboard /><span>Dashboard</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                      <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard/admin-projects" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <FolderKanban /><span>Projects</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                       <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard/admin-images" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <ImageIcon /><span>Images</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                      <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard/settings" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <SettingsIcon /><span>Settings</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                       <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard#services" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <Briefcase /><span>Services</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                      <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard#news" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <Newspaper /><span>News & Insights</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                      <SidebarMenuItem>
                        <SheetClose asChild>
                          <Link href="/staff-portal/dashboard/profile" asChild>
                            <SidebarMenuButton className="w-full justify-start">
                              <UserCircle /><span>Profile</span>
                            </SidebarMenuButton>
                          </Link>
                        </SheetClose>
                      </SidebarMenuItem>
                    </SidebarMenu>
                  </SidebarContent>
                  <SidebarFooter className="p-4 border-t mt-auto"> 
                    <LogoutButton />
                  </SidebarFooter>
                </div>
              </SheetContent>
            </Sheet>
             <Link href="/staff-portal/dashboard" className="flex items-center gap-2 ml-4">
                <Image src={currentLogoUrl} alt={`${APP_NAME} Logo`} width={28} height={28} className="object-contain" />
                <span className="text-md font-semibold text-primary text-shadow-primary">
                  {`${APP_NAME} Staff`}
                </span>
              </Link>
          </header>

          <main className="flex-1 p-6 sm:p-8 md:p-10 overflow-y-auto bg-background">
            {children}
          </main>
        </div>
      </div>
    </SidebarProvider>
  );
}
    
