
"use client";

import { useAuthContext } from '@/hooks/use-auth-context';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { Spinner } from '@/components/ui/spinner';
import { APP_NAME } from '@/constants';
import { UserCircle, CheckCircle, XCircle } from 'lucide-react';
import type { Metadata } from 'next'; // For static metadata definition for this wrapper/redirector page
import { useEffect } from 'react';


// export const metadata: Metadata = { // Cannot export from client component
//   title: `User Profile | ${APP_NAME} Staff Portal`,
//   robots: {
//     index: false,
//     follow: false,
//   },
// };


export default function ProfilePage() {
  const { user, loading } = useAuthContext();

  useEffect(() => {
    if (typeof window !== 'undefined') {
        document.title = `User Profile | ${APP_NAME} Staff Portal`;
    }
  }, []);

  if (loading) {
    return (
      <div className="flex items-center justify-center h-full">
        <Spinner size="large" />
      </div>
    );
  }

  if (!user) {
    return (
      <div className="flex items-center justify-center h-full">
        <p>User not found. Please try logging in again.</p>
      </div>
    );
  }

  return (
    <div className="w-full space-y-6">
      <Card className="shadow-lg">
        <CardHeader className="text-center">
          <UserCircle className="h-16 w-16 text-primary mx-auto mb-4" />
          <CardTitle className="text-2xl font-bold text-primary text-shadow-primary">User Profile</CardTitle>
          <CardDescription>View and manage your account details.</CardDescription>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="space-y-2">
            <h3 className="text-lg font-semibold text-foreground">Account Information</h3>
            <div className="p-4 border rounded-md bg-muted/50 space-y-2">
              <p>
                <strong className="text-foreground">Display Name:</strong>{' '}
                <span className="text-muted-foreground">{user.displayName || 'Not set'}</span>
              </p>
              <p>
                <strong className="text-foreground">Email:</strong>{' '}
                <span className="text-muted-foreground">{user.email}</span>
              </p>
              <p>
                <strong className="text-foreground">UID:</strong>{' '}
                <span className="text-muted-foreground text-xs">{user.uid}</span>
              </p>
              <p className="flex items-center">
                <strong className="text-foreground mr-2">Email Verified:</strong>
                {user.emailVerified ? (
                  <Badge variant="default" className="bg-green-500 hover:bg-green-600 text-white">
                    <CheckCircle className="mr-1 h-4 w-4" /> Verified
                  </Badge>
                ) : (
                  <Badge variant="destructive">
                    <XCircle className="mr-1 h-4 w-4" /> Not Verified
                  </Badge>
                )}
              </p>
            </div>
          </div>
          
          <div className="space-y-2">
            <h3 className="text-lg font-semibold text-foreground">Account Management</h3>
            <div className="p-4 border rounded-md bg-muted/50">
                <p className="text-muted-foreground text-sm">
                    Features to update your profile (e.g., display name, password) will be available soon.
                </p>
            </div>
          </div>

          <div className="space-y-2">
            <h3 className="text-lg font-semibold text-foreground">Roles & Permissions</h3>
            <div className="p-4 border rounded-md bg-muted/50">
                <p className="text-muted-foreground text-sm">
                    Admin roles and specific permissions (including Super Admin capabilities) are planned for future development.
                    Currently, all logged-in staff have access to available dashboard sections.
                </p>
                 {user.email === "xphine10@gmail.com" && (
                    <p className="text-sm text-accent font-semibold mt-2">
                        Note: This account ({user.email}) is designated as a Super Admin. Enhanced privileges will be activated in a future update.
                    </p>
                 )}
            </div>
          </div>

        </CardContent>
      </Card>
    </div>
  );
}
