import Link from "next/link";
import { Button } from "@/components/ui/button";
import { ArrowRight } from "lucide-react";
import { APP_NAME } from "@/constants";

export function HeroSection() {
  return (
    <section className="py-20 md:py-32 bg-gradient-to-b from-background to-primary/5">
      <div className="container mx-auto px-4 text-center">
        <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-primary mb-6 text-shadow-primary">
          {APP_NAME}
        </h1>
        <p className="text-xl md:text-2xl text-foreground mb-4 max-w-3xl mx-auto">
          Empowering Communities, Driving Sustainable Growth in East Africa.
        </p>
        <p className="text-lg text-muted-foreground mb-10 max-w-2xl mx-auto">
          We specialize in financial inclusion, enterprise development, and experiential marketing, with a focus on empowering women and youth through financial literacy, agribusiness training, and innovative digital solutions.
        </p>
        <div className="flex flex-col sm:flex-row justify-center gap-4">
          <Button asChild size="lg" className="text-lg px-8 py-6">
            <Link href="/services">
              Explore Our Services <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </Button>
          <Button asChild variant="outline" size="lg" className="text-lg px-8 py-6">
            <Link href="/about">
              Learn More About Us
            </Link>
          </Button>
        </div>
      </div>
    </section>
  );
}
