
"use client";

import { usePathname } from "next/navigation";
import { Navbar } from "@/components/layout/navbar";
import { Footer } from "@/components/layout/footer";
import { FloatingAssistant } from "@/components/ai/floating-assistant";
import type { ReactNode } from "react";

export function MainAppShell({ children }: { children: ReactNode }) {
  const pathname = usePathname();
  // usePathname can return null during the initial render or specific scenarios, handle it gracefully.
  const isStaffPortal = pathname ? pathname.startsWith('/staff-portal') : false;

  return (
    <>
      {!isStaffPortal && <Navbar />}
      <main className="flex-grow px-4 py-6 sm:px-6 sm:py-8 lg:px-8">
        {children}
      </main>
      {!isStaffPortal && <Footer />}
      {!isStaffPortal && <FloatingAssistant />}
    </>
  );
}
