
"use client";

import Image from 'next/image';

interface ProjectDetailImageProps {
  src?: string | null;
  alt: string;
  title: string; // Used for placeholder text
  imageHint?: string;
}

export function ProjectDetailImage({ src, alt, title, imageHint }: ProjectDetailImageProps) {
  const placeholderSrc = `https://placehold.co/600x400.png?text=${encodeURIComponent(title)}`;
  const imageSrc = src || placeholderSrc;

  return (
    <div className="relative w-full aspect-[3/2] rounded-lg overflow-hidden shadow-xl bg-muted">
      <Image
        src={imageSrc}
        alt={alt}
        fill
        style={{ objectFit: 'cover' }}
        data-ai-hint={imageHint || 'project details'}
        priority
        onError={(e) => {
          const target = e.target as HTMLImageElement;
          // Attempt to set to a generic placeholder if the provided src fails
          if (target.src !== placeholderSrc) { // Avoid infinite loop if placeholder itself fails
            target.srcset = `https://placehold.co/600x400.png?text=Image+Error`;
            target.src = `https://placehold.co/600x400.png?text=Image+Error`;
          }
        }}
      />
    </div>
  );
}
