
"use client";

import Image from 'next/image';

interface ProjectAdminImageProps {
  src: string | undefined | null; // Allow undefined or null
  alt: string;
  imageHint?: string;
}

export function ProjectAdminImage({ src, alt, imageHint }: ProjectAdminImageProps) {
  const imageSrc = src && (src.startsWith('http://') || src.startsWith('https://') || src.startsWith('/'))
                  ? src
                  : `https://placehold.co/80x80.png?text=NoImg`;

  return (
    <div className="relative h-10 w-10 sm:h-12 sm:w-12 rounded-md overflow-hidden border bg-muted">
      <Image
        src={imageSrc}
        alt={alt}
        fill
        style={{ objectFit: 'cover' }}
        data-ai-hint={imageHint || 'project details'}
        sizes="(max-width: 640px) 40px, 48px"
        onError={(e) => {
          e.currentTarget.srcset = `https://placehold.co/80x80.png?text=Err`;
          e.currentTarget.src = `https://placehold.co/80x80.png?text=Err`;
        }}
      />
    </div>
  );
}
