
import type { NavLink, Service } from "@/types"; // Project type removed here as it's used below
import { Briefcase, Users, Lightbulb, Megaphone, MapPin, Mail, Phone, Linkedin, Twitter, Facebook, Settings as SettingsIcon, ImageIcon, FolderKanban, Newspaper, UserCircle } from "lucide-react"; // Added more icons that might be used
import type { OfficeContact, SocialLink, Project } from "@/types"; // Ensure Project is imported here

export const APP_NAME = "Intelli-Wealth Limited";
export const APP_DESCRIPTION = "Empowering Communities, Driving Growth.";

export const LOGO_URL = "https://files.tari.africa/api.php?path=public&name=1748363304_6835e828253df.png&token=463110cd7e0c889e9d7f03b9bc1b77694b26581d92e0d8a211fd2a545715335c";
export const TARI_PROJECT_IMAGES_FOLDER = "projects";
export const TARI_GENERAL_IMAGES_FOLDER = "uploads";
export const TARI_SITE_ASSETS_FOLDER = "site-assets";

export const NAV_LINKS: NavLink[] = [
  { href: "/", label: "Home" },
  { href: "/about", label: "About Us" },
  { href: "/services", label: "Services" },
  { href: "/intellicash", label: "IntelliCash", icon: "https://files.tari.africa/api.php?path=public&name=1748418560_6836c0007e32e.png" },
  { href: "/projects", label: "Projects" },
  { href: "/news-insights", label: "News & Insights" },
  { href: "/contact", label: "Contact Us" },
];

export const SOCIAL_LINKS: SocialLink[] = [
  { name: "Facebook", href: "https://facebook.com/intelliwealth", icon: Facebook },
  { name: "Twitter", href: "https://twitter.com/intelliwealth", icon: Twitter },
  { name: "LinkedIn", href: "https://linkedin.com/company/intelliwealth", icon: Linkedin },
];

export const CORE_SERVICES: Service[] = [
  {
    id: "enterprise-development",
    title: "Enterprise Development Services",
    description: "Tailored solutions to foster SME growth and market access.",
    icon: Briefcase,
    details: [
      "Customized Business Development Services (BDS)",
      "Facilitating access to finance for SMEs",
      "Value chain development",
      "Capacity building and training",
      "Market access and information dissemination",
    ],
  },
  {
    id: "financial-inclusion",
    title: "Financial Inclusion",
    description: "Empowering communities through financial literacy and VSLA programs.",
    icon: Users,
    details: [
      "Establishment and digitization of Village Savings and Loan Associations (VSLAs)",
      "Financial literacy training",
      "Partnerships with development organizations",
      "Implementation of Management Information Systems (MIS) for transparency",
    ],
  },
  {
    id: "digital-innovation",
    title: "Digital Innovation",
    description: "Leveraging technology to enhance transparency and efficiency in community finance. Discover solutions like IntelliCash.",
    icon: Lightbulb,
    details: [
      "Development of digital platforms for VSLA management (like IntelliCash)",
      "Streamlining operations to improve transparency and efficiency",
      "Empowering rural communities through technology",
      "Fintech solutions for community savings groups",
    ],
  },
  {
    id: "experiential-marketing",
    title: "Experiential Marketing",
    description: "Creating impactful brand experiences across East Africa.",
    icon: Megaphone,
    details: [
      "Brand activations and roadshows",
      "Product launches and consumer engagement campaigns",
      "Outdoor advertising and merchandising",
      "Operations across Kenya, Uganda, Tanzania, and Rwanda",
    ],
  },
];

// Define a type for the static project data, excluding fields Firestore will manage
// or that are set during seeding (like auto-ID, createdAt, imageUrl, imagePathTari)
export type StaticProjectSeedData = {
  // staticId can be used if you had unique identifiers in your original static data,
  // otherwise it's not strictly needed if Firestore generates IDs.
  // For this example, I'm keeping it as it was in the original commented data.
  staticId: string; 
  title: string;
  organization: string;
  description: string;
  imageHint: string;
  impact: string[];
  // You could add a staticCreatedAt if you want to preserve original dates,
  // but it would need to be converted to a Firestore Timestamp during seeding.
  // staticCreatedAt?: string; 
};


// KEY_PROJECTS is now sourced from Firestore for public display.
// This static data can be used to seed the database initially via the new server action.
// Ensure 'id' is unique (e.g., Firestore auto-ID or your chosen slug).
// 'imageUrl' will be set by the seeding function to the default.
// 'imagePathTari' will be set to null or undefined by the seeding function.
// 'createdAt' will be a Firestore serverTimestamp during seeding.
export const KEY_PROJECTS_SEED_DATA: StaticProjectSeedData[] = [
  {
    staticId: "world-vision", 
    title: "Rural Financial Inclusion Enhancement",
    organization: "World Vision",
    description: "Conducted awareness and training sessions to enhance rural financial inclusion through the establishment and digitization of VSLAs.",
    imageHint: "community finance",
    impact: ["Increased financial literacy in rural areas", "Digitized VSLA operations for better tracking", "Empowered local communities with savings tools"],
  },
  {
    staticId: "care-fsd",
    title: "VSLA Curriculum & Digital System Development",
    organization: "CARE International & FSD Kenya",
    description: "Developed a VSLA curriculum and digital recording system, providing capacity building on technology-enhanced VSLA systems.",
    imageHint: "education technology",
    impact: ["Standardized VSLA training materials", "Implemented user-friendly digital recording tools", "Strengthened VSLA management capabilities"],
  },
  {
    staticId: "finn-church-aid",
    title: "VSLA & Enterprise Development via Waste Management",
    organization: "Finn Church Aid",
    description: "Established VSLAs and promoted enterprise development through waste management initiatives in Nairobi, Kajiado, and Mombasa.",
    imageHint: "sustainability waste",
    impact: ["Created income-generating opportunities from waste", "Improved environmental conditions", "Fostered entrepreneurship within VSLAs"],
  },
  {
    staticId: "farm-africa",
    title: "Agribusiness & Financial Training for Farmers",
    organization: "FARM Africa",
    description: "Provided training on financial management, agribusiness development, and VSLA methodologies for farmers and worker committees in Kenya's coastal region.",
    imageHint: "agriculture training",
    impact: ["Enhanced financial management skills for farmers", "Improved agribusiness practices", "Strengthened VSLA methodologies in agricultural communities"],
  },
];


export const CONTACT_INFO = {
  mainEmail: "info@intelli-wealth.org",
  mainPhone: "+254 723 242 701",
  website: "www.intelli-wealth.org",
  offices: [
    {
      location: "Kenya (Head Office)",
      icon: MapPin,
      addressLines: ["Ramco Courts, Along Mombasa Road", "Opposite Capital Center Mall, Nairobi"],
      poBox: "P.O. Box 43864-00100 GPO",
    },
    {
      location: "Uganda Office",
      icon: MapPin,
      addressLines: ["4th Floor, Padre Pio House", "Kampala"],
      poBox: "P.O. Box 105550, Kampala",
      email: "info.ug@intelli-wealth.org",
      phone: "+256 393 254 145",
    },
  ] as OfficeContact[],
};

// Mock data for Dynamic Content Suggestions
export const MOCK_AVAILABLE_CONTENT = [
  { id: "blog1", title: "The Future of VSLAs: Digital Transformation", type: "blog post", description: "Exploring how technology is reshaping Village Savings and Loan Associations." },
  { id: "service1", title: "Customized BDS for Agribusinesses", type: "service offering", description: "Learn about our tailored Business Development Services for the agricultural sector." },
  { id: "blog2", title: "Financial Literacy: A Pillar for Youth Empowerment", type: "blog post", description: "Why financial education is crucial for the economic empowerment of young people." },
  { id: "service2", title: "Experiential Marketing in Rural Markets", type: "service offering", description: "Strategies for effective brand engagement in East Africa's rural communities." },
  { id: "blog3", title: "Impact of Microfinance on Women Entrepreneurs", type: "blog post", description: "A deep dive into how microfinance is supporting women-led businesses." },
  { id: "product1", title: "IntelliCash for Chamas", type: "product", description: "Discover IntelliCash, our SaaS platform for digitizing Chama operations." },
];

export const MOCK_INDUSTRY_TRENDS = "Key trends include the rapid adoption of mobile money, increasing focus on climate-resilient agriculture, and the rise of digital platforms for SME financing in East Africa.";

// This would typically be dynamic based on user activity
export const MOCK_USER_BEHAVIOR = "User spent 5 minutes on the 'Financial Inclusion' services page and 3 minutes on a project related to 'VSLA digitization'. User also briefly visited the 'About Us' page focusing on community empowerment.";
