
"use client";

import type { ReactNode } from 'react';
import { createContext, useContext } from 'react';
import type { SiteSettings } from '@/types';

// We only strictly need logoUrl for now from settings, but can expand later
interface SiteSettingsContextType extends Partial<SiteSettings> {}

const SiteSettingsContext = createContext<SiteSettingsContextType | null>(null);

export function SiteSettingsProvider({
  children,
  settings,
}: {
  children: ReactNode;
  settings: SiteSettingsContextType | null;
}) {
  return (
    <SiteSettingsContext.Provider value={settings}>
      {children}
    </SiteSettingsContext.Provider>
  );
}

export function useSiteSettingsContext(): SiteSettingsContextType | null {
  const context = useContext(SiteSettingsContext);
  // It's okay for context to be null if settings are not found,
  // components will handle fallback.
  return context;
}
